import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Name;
import org.uddi4j.response.ServiceInfo;
import org.uddi4j.response.ServiceInfos;
import org.uddi4j.response.ServiceList;
import org.uddi4j.transport.TransportFactory;
import org.uddi4j.util.FindQualifier;
import org.uddi4j.util.FindQualifiers;
import java.util.Vector;

public class UDDIFindService2 {

	public static void main(String[] args) throws Exception {

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");

		Vector fqv = new Vector();
		FindQualifier fq = new FindQualifier(FindQualifier.sortByNameDesc);
		fqv.addElement(fq);
		FindQualifiers fqs = new FindQualifiers();
		fqs.setFindQualifierVector(fqv);

		Vector names = new Vector();
		names.add(new Name("%registr%"));
		ServiceList sl = proxy.find_service("D2033110-3AAF-11D5-80DC-002035229C64", names, null, null, fqs, 0);

		ServiceInfos sis = sl.getServiceInfos();
		if (sis.size() == 0) {
			System.out.println("no service(s) found");
			System.exit(0);
		}

		System.out.println(sis.size()+" service(s) found\n");
		Vector siv = sis.getServiceInfoVector();
		for (int i = 0; i < siv.size(); i++) {
			ServiceInfo si = (ServiceInfo)siv.elementAt(i);
			System.out.println(si.getNameString());
			System.out.println(si.getServiceKey());
			System.out.println("\n");
		}
	}
}